package com.roboprogs.util.hash;

import java.util.*;

/**
 * A utility class to make it easier to do some things with java Maps
 *  similar to Perl / Ruby "hash" idioms.
 *  <p>
 *  Note that I did not (yet) use java 1.5 style templated types.
 *  Given the weakly typed, dynamic language, code style that
 *  this class is helping to emulate, this is probably no loss.
 *  </p>
 *  <p>
 *  Created by: Rob Anderson.
 *  </p>
 *  <p>
 *  Released under the LGPL.
 *  </p>
 */
public
class					Hash
	{

	/**
	 * Return a Map constructed from the given array.
	 *  TODO:  templated java 1.5 types?
	 *
	 * @param			keyValPairs		pairs of values,
	 *									the first of each is the key,
	 *									the next the value.
	 */
	public static
	Map					newMap
		(
		Object []		keyValPairs
		)
		{
		return Hash.mapPutAll( new HashMap(), keyValPairs);
		}

	/**
	 * Fill a Map with entries from the given array.
	 *  TODO:  templated java 1.5 types?
	 *
	 * @param			map				an existing Map,
	 *									to which the entries will be added.
	 * @param			keyValPairs		pairs of values,
	 *									the first of each is the key,
	 *									the next the value.
	 */
	public static
	Map					mapPutAll
		(
		Map				map,
		Object []		keyValPairs
		)
		{
		int				idx;
		
		for ( idx = 0; idx < keyValPairs.length; idx += 2)
		
			{
			map.put( keyValPairs[ idx ], keyValPairs[ idx + 1 ]);
			}
			
		return map;
		}
		
	// ------------------------------------------

	/**
	 * Test harness for Hash utility.
	 *  TODO:  junit?
	 */
	public static
	void				main
		(
		String []		argv
		)
		{
		Map				result;
		
		// return a hash, er, map, instead of a list, peel out return vals
		result = demoFunc( "sub_command_A", Hash.newMap( new Object []
			{
			"in1",	"X",
			"in2",	new Integer( 0),
			"in3",	new Date()
			} ) );
		System.out.println( result);
		System.out.println( "out1: " + result.get( "out1") +
				"; out2: " + result.get( "out2") +
				"; out3: " + result.get( "out3") );
		}

	/**
	 * Simulate doing something useful.
	 */
	private static
	Map					demoFunc
		(
		String			subCmd,
		Map				nameValArgs
		)
		{
		// pretend that there are dozens of lines of biz "logic" here
		return Hash.newMap( new Object []
			{
			"out2", nameValArgs.get( "in1"),
			"out3", nameValArgs.get( "in2"),
			"out1", nameValArgs.get( "in3")
			} );
		}

	}

// ****** EOF ******
